package cn.blankcat.dto.permission;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

// APIPermissionDemand 接口权限需求对象
@JsonIgnoreProperties(ignoreUnknown = true)
public record APIPermissionDemand (
        // 频道 ID
        @JsonProperty("guild_id")
        String guildId,
        // 子频道 ID
        @JsonProperty("channel_id")
        String channelId,
        // 权限接口唯一标识
        @JsonProperty("api_identify")
        APIPermissionDemandIdentify APIIdentify,
        // 接口权限链接中的接口权限描述信息
        String title,
        // 接口权限链接中的机器人可使用功能的描述信息
        String desc
){}
