package cn.blankcat.dto.permission;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public record APIPermission (
        // API 接口名，例如 /guilds/{guild_id}/members/{user_id}
        String path,
        // 请求方法，例如 GET
        String method,
        // API 接口名称，例如 获取频道信息
        String desc,
        // 授权状态，auth_stats 为 1 时已授权
        @JsonProperty("auth_status")
        String authStatus
){}
