package cn.blankcat.dto.pager;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown = true)
// GuildRoleMembersPager 分页器
public record MessagesPager (

        // 拉取类型
        MessagePagerType type,
        // 消息ID
        String id,
        // 最大 20
        String limit
){

    public static MessagesPager defaultPager = new MessagesPager(MessagePagerType.MPT_AFTER, "", "20");


    // MessagePagerType 消息翻页拉取方式
    public enum MessagePagerType {
        MPT_AROUND("around"),
        MPT_BEFORE("before"),
        MPT_AFTER("after");

        private final String value;

        MessagePagerType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }
    }

    public Map<String, String> QueryParams() {
        HashMap<String,String> query = new HashMap<>();
        if (!"".equals(this.limit)){
            query.put("limit", this.limit);
        }
        if (!"".equals(this.type.value) && !"".equals(this.id)){
            query.put(this.type.value, this.id);
        }
        return query;
    }
    
}
