package cn.blankcat.dto.pager;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown = true)
// MessageReactionPager 分页器
public record MessageReactionPager (
        // 分页游标
        String cookie,
        // 分页大小，1-1000，默认是20
        String limit
){
    public static MessageReactionPager defaultPager = new MessageReactionPager("", "20");

    public Map<String, String> QueryParams() {
        HashMap<String,String> query = new HashMap<>();
        if (!"".equals(this.limit)){
            query.put("limit", this.limit);
        }
        if (!"".equals(this.cookie)){
            query.put("cookie", this.cookie);
        }
        return query;
    }
    
}
