package cn.blankcat.dto.pager;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown = true)
// GuildRoleMembersPager 分页器
public record GuildRoleMembersPager (
        @JsonProperty("start_index")
        String startIndex,
        String limit
){

    public static GuildRoleMembersPager defaultPager = new GuildRoleMembersPager("", "10");

    public Map<String, String> QueryParams() {
        HashMap<String,String> query = new HashMap<>();
        if (!"".equals(this.limit)){
            query.put("limit", this.limit);
        }
        if (!"".equals(this.startIndex)){
            query.put("start_index", this.startIndex);
        }
        return query;
    }
    
}
