package cn.blankcat.dto.pager;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown = true)
// GuildRoleMembersPager 分页器
public record GuildPager (
        // 读此id之前的数据
        String before,
        // 读此id之后的数据
        String after,
        // 分页大小，1-100，默认是 100
        String limit
){

    public static GuildPager defaultPager = new GuildPager("", "", "100");

    public Map<String, String> QueryParams() {
        HashMap<String,String> query = new HashMap<>();
        if (this.limit != null && !"".equals(this.limit)){
            query.put("limit", this.limit);
        }
        if (this.after != null && !"".equals(this.after)){
            query.put("after", this.after);
        }
        if (this.before != null && !"".equals(this.before)){
            query.put("before", this.before);
        }
        return query;
    }
    
}
