package cn.blankcat.dto.pager;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown = true)
// GuildMembersPager 分页器
public record GuildMembersPager (
        // 读此id之后的数据，如果是第一次请求填0，默认为0
        String after,
        // 分页大小，1-1000，默认是1
        String limit
){

    public static GuildMembersPager defaultPager = new GuildMembersPager("0", "1");

    public Map<String, String> QueryParams() {
        HashMap<String,String> query = new HashMap<>();
        if (!"".equals(this.limit)){
            query.put("limit", this.limit);
        }
        if (!"".equals(this.after)){
            query.put("after", this.after);
        }
        return query;
    }

}
