package cn.blankcat.dto.message;

import cn.blankcat.dto.keyboard.MessageKeyboard;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
// MessageToCreate 发送消息结构体定义
public record MessageToCreate (
        String content,
        Embed embed,
        Ark ark,
        String image,
        // 要回复的消息id，为空是主动消息，公域机器人会异步审核，不为空是被动消息，公域机器人会校验语料
        @JsonProperty("msg_id")
        String msgId,
        @JsonProperty("message_reference")
        MessageReference messageReference,
        Markdown markdown,
        MessageKeyboard keyboard,
        @JsonProperty("event_id")
        String eventId
){}
