package cn.blankcat.dto.message;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

// MessageAudit 消息审核结构体定义
@JsonIgnoreProperties(ignoreUnknown = true)
public record MessageAudit (
        // 审核 ID
        @JsonProperty("audit_id")
        String auditId,
        // 消息 ID
        @JsonProperty("message_id")
        String messageId,
        // 频道 ID
        @JsonProperty("guild_id")
        String guildId,
        // 子频道 ID
        @JsonProperty("channel_id")
        String channelId,
        // 审核时间
        @JsonProperty("audit_time")
        String auditTime,
        // 创建时间
        @JsonProperty("create_time")
        String createTime,
        // 子频道 seq，用于消息间的排序，seq 在同一子频道中按从先到后的顺序递增，不同的子频道之前消息无法排序
        @JsonProperty("seq_in_channel")
        String seqInChannel
){}
