package cn.blankcat.dto.message;

import cn.blankcat.dto.member.Member;
import cn.blankcat.dto.member.User;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
// Message 消息结构体定义
public record Message (
        // 消息ID
        String id,
        // 子频道ID
        @JsonProperty("channel_id")
        String channelId,
        // 频道ID
        @JsonProperty("guild_id")
        String guildId,
        // 内容
        String content,
        // 发送时间
        String timestamp,
        // 消息编辑时间
        @JsonProperty("edited_timestamp")
        String editedTimestamp,
        // 是否@all
        @JsonProperty("mention_everyone")
        String mentionEveryone,
        // 消息发送方
        User author,
        // 消息发送方Author的member属性，只是部分属性
        Member member,
        // 附件
        MessageAttachment attachments,
        // 结构化消息-embeds
        Embed[] embeds,
        // 消息中的提醒信息(@)列表
        User[] mentions,
        // ark 消息
        Ark ark,
        // 私信消息
        @JsonProperty("direct_message")
        Boolean directMessage,
        // 子频道 seq，用于消息间的排序，seq 在同一子频道中按从先到后的顺序递增，不同的子频道之前消息无法排序
        @JsonProperty("seq_in_channel")
        String seqInChannel,
        // 引用的消息
        @JsonProperty("message_reference")
        MessageReference messageReference,
        // 私信场景下，该字段用来标识从哪个频道发起的私信
        @JsonProperty("src_guild_id")
        String srcGuildId
){}
