package cn.blankcat.dto.member;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
// Member 群成员
public record User (
        String id,
        String username,
        String avatar,
        Boolean bot,
        // 特殊关联应用的 openid
        @JsonProperty("union_openid")
        String unionOpenId,
        // 机器人关联的用户信息，与union_openid关联的应用是同一个
        @JsonProperty("union_user_account")
        String unionUserAccount
){}
