package cn.blankcat.dto.keyboard;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

// Permission 按纽操作权限
@JsonIgnoreProperties(ignoreUnknown = true)
public record Permission (
        // Type 操作权限类型
        PermissionType type,
        // SpecifyRoleIDs 身份组
        @JsonProperty("specify_role_ids")
        String specifyRoleIds,
        // SpecifyUserIDs 指定 UserID
        @JsonProperty("specify_user_ids")
        String specifyUserIds
){

    // PermissionType 按钮的权限类型
    public enum PermissionType {
        PERMISSION_TYPE_SPECIFY_USER_IDS(0), // PermissionTypeSpecifyUserIDs 仅指定这条消息的人可操作
        PERMISSION_TYPE_MANAGER(1),          // PermissionTypManager  仅频道管理者可操作
        PERMISSION_TYPE_ALL(2),              // PermissionTypAll  所有人可操作
        PERMISSION_TYPE_SPECIFY_ROLE_IDS(3); // PermissionTypSpecifyRoleIDs 指定身份组可操作

        private final int value;

        PermissionType(int value) {
            this.value = value;
        }

        @JsonValue
        public int getValue() {
            return value;
        }
    }

}
