package cn.blankcat.dto.keyboard;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

// Action 按纽点击操作
@JsonIgnoreProperties(ignoreUnknown = true)
public record Action (
        // 操作类型
        ActionType type,
        // 可操作
        Permission permission,
        // 可点击的次数, 默认不限
        @JsonProperty("click_limit")
        long clickLimit,
        // 操作相关数据
        long data,
        // false:当前 true:弹出展示子频道选择器
        @JsonProperty("at_bot_show_channel_list")
        long atBotShowChannelList
){

    // ActionType 按钮操作类型
    public enum ActionType {
        ACTION_TYPE_URL(0),       // ActionTypeURL http 或 小程序 客户端识别 schema, data字段为链接
        ACTION_TYPE_CALLBACK(1),  // ActionTypeCallback 回调互动回调地址, data 传给互动回调地址
        ACTION_TYPE_AT_BOT(2);    // ActionTypeAtBot at机器人, 根据 at_bot_show_channel_list 决定在当前频道或用户选择频道,自动在输入框 @bot data

        private final int value;

        ActionType(int value) {
            this.value = value;
        }

        @JsonValue
        public int getValue() {
            return value;
        }
    }

}
