package cn.blankcat.dto.interaction;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonIgnoreProperties(ignoreUnknown = true)
// InteractionData 互动数据
public record InteractionData (
        // 应用ID
        String name,
        InteractionDataType type,
        Object resolved
){

    // InteractionDataType 互动数据类型
    public enum InteractionDataType{
        INTERACTION_DATA_TYPE_CHAT_SEARCH(9); // InteractionDataTypeChatSearch 聊天框搜索
        private final long value;
        InteractionDataType(long value){
            this.value = value;
        }
        @JsonValue
        public long getValue(){
            return value;
        }
    }

}
