package cn.blankcat.dto.interaction;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
@JsonIgnoreProperties(ignoreUnknown = true)
// Interaction 互动行为对象
public record Interaction (
        // 互动行为唯一标识
        String id,
        // 应用ID
        @JsonProperty("application_id")
        String applicationId,
        // 互动类型
        InteractionType type,
        // 互动数据
        InteractionData data,
        // 频道 ID
        @JsonProperty("guild_id")
        String guildId,
        // 子频道 ID
        @JsonProperty("channel_id")
        String channelId,
        //	版本，默认为 1
        long version
){

    // InteractionType 互动类型
    public enum InteractionType{
        INTERACTION_TYPE_PING(1),
        INTERACTION_TYPE_COMMAND(2);
        private final long value;
        InteractionType(long value){
            this.value = value;
        }
        @JsonValue
        public long getValue(){
            return value;
        }
    }

}
