package cn.blankcat.dto.guild;

import cn.blankcat.dto.channel.Channel;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
// Guild 频道结构定义
public record Guild (
        // 频道ID（与客户端上看到的频道ID不同）
        String id,
        // 频道名称
        String name,
        // 频道头像
        String icon,
        // 拥有者ID
        @JsonProperty("owner_id")
        String ownerId,
        // 是否为拥有者
        Boolean owner,
        // 成员数量
        @JsonProperty("member_count")
        int memberCount,
        // 最大成员数目
        @JsonProperty("max_members")
        long maxMembers,
        // 频道描述
        @JsonProperty("description")
        String desc,
        // 当前用户加入群的时间
        // 此字段只在GUILD_CREATE事件中使用
        @JsonProperty("joined_at")
        String joinedAt,
        // 频道列表
        List<Channel> channels,
        // 游戏绑定公会区服ID
        @JsonProperty("union_world_id")
        String unionWorldId,
        // 游戏绑定公会/战队ID
        @JsonProperty("union_org_id")
        String unionOrgId,
        @JsonProperty("op_user_id")
        String OpUserId
){}
