package cn.blankcat.dto.audio;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonIgnoreProperties(ignoreUnknown = true)
public record AudioControl (
        // AudioControl 音频控制对象
        @JsonProperty("audio_url")
        String url,
        String text,
        @JsonProperty("status")
        AudioStatus audioStatus
){
    // 音频状态
    public enum AudioStatus{
        AUDIO_STATUS_START(0),
        AUDIO_STATUS_PAUSE(1),
        AUDIO_STATUS_RESUME(2),
        AUDIO_STATUS_STOP(3);
        private final long value;
        AudioStatus(long value){
            this.value = value;
        }
        @JsonValue
        public long getValue(){
            return value;
        }
    }

}
