package cn.blankcat.websocket.v1;

import cn.blankcat.dto.websocket.Session;
import cn.blankcat.dto.websocket.ShardConfig;
import cn.blankcat.dto.websocket.WSEvent;
import cn.blankcat.dto.websocket.WebsocketAP;
import cn.blankcat.openapi.v1.OpenApi;
import cn.blankcat.openapi.v1.service.WsService;
import cn.blankcat.token.Token;
import cn.blankcat.websocket.v1.service.WebsocketService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Retrofit;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class WebsocketManager {

    private static final Logger logger = LoggerFactory.getLogger("WebsocketManager");
    private static final ExecutorService threadPool = Executors.newCachedThreadPool();
    private static final long concurrencyTimeWindowSec = 2;

    public void run(){
        run(null , false, 3);
    }

        public void run (Token token, Boolean inSandbox, Integer timeout){
        try {
            Retrofit restyClient = OpenApi.getClient(token, inSandbox, timeout);
            WebsocketAP apiInfo = restyClient.create(WsService.class).ws().execute().body();
            if (apiInfo == null){
                logger.error("websocket配置信息获取失败...");
                return;
            }
            start(apiInfo, OpenApi.getData().getToken(), WSEvent.allEventToIntent());
        }catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void start(WebsocketAP apiInfo, Token token, int intents){
        long startInterval = calcInterval(apiInfo.getSessionStartLimit().getMaxConcurrency());
        logger.info("即将以{}s每个的间隔启动{}个sessions...", startInterval, apiInfo.getShards());
        for (int i = 0; i< apiInfo.getShards(); i++){
            ShardConfig shards = new ShardConfig();
            shards.setShardID(i);
            shards.setShardCount(apiInfo.getShards());

            Session session = new Session();
            session.setId("");
            session.setUrl(apiInfo.getUrl());
            session.setToken(token);
            session.setIntent(intents);
            session.setLastSeq(0);
            session.setShards(shards);

            threadPool.execute(()->{
                newConnect(session);
            });
        }
    }

    private long calcInterval(long maxConcurrency){
        if (maxConcurrency == 0){
            maxConcurrency = 1;
        }
        int i = Math.round((float) concurrencyTimeWindowSec / maxConcurrency);
        return i <= 0 ? 1 : i;
    }

    private boolean newConnect(Session session){
        WebsocketApi wsApi = new WebsocketService().init(session);
        if (!"".equals(session.getId())){
            if (!wsApi.resume()){
                Session currentSession = wsApi.session();
                currentSession.setId("");
                currentSession.setLastSeq(0);
                return false;
            }
        }else {
            if (!wsApi.identify()){
                logger.error("鉴权失败，进程退出...");
                return false;
            }
        }
        return true;
    }

}
