package cn.blankcat.openapi.v1.service;

import cn.blankcat.dto.message.Message;
import cn.blankcat.dto.message.MessageToCreate;
import cn.blankcat.dto.message.SettingGuideToCreate;
import cn.blankcat.openapi.v1.Resource;
import retrofit2.Call;
import retrofit2.http.*;

import java.util.Map;

public interface MessageService{

    // Message 拉取单条消息
    @GET(Resource.messageURI)
    Call<Message> message(@Path("channel_id") String channelID,
                          @Path("message_id") String messageID);

    // Messages 拉取消息列表
    @GET(Resource.messagesURI)
    Call<Message[]> messages(@Path("channel_id") String channelID,
                          @QueryMap Map<String, String> messagePager);

    // PostMessage 发消息
    @POST(Resource.messagesURI)
    Call<Message> postMessage(@Path("channel_id") String channelID,
                             @Body MessageToCreate msg);

    // PatchMessage 编辑消息
    @PATCH(Resource.messageURI)
    Call<Message> patchMessage(@Path("channel_id") String channelID,
                              @Path("message_id") String messageID,
                              @Body MessageToCreate msg);

    // RetractMessage 撤回消息
    @DELETE(Resource.messageURI)
    Call<String> retractMessage(@Path("channel_id") String channelID,
                                @Path("message_id") String msgID);

    // PostSettingGuide 发送设置引导消息, atUserID为要at的用户
    @POST(Resource.settingGuideURI)
    Call<Message> postSettingGuide(@Path("channel_id") String channelID,
                                   @Body SettingGuideToCreate msg);


}
