package cn.blankcat.openapi.v1.service;

import cn.blankcat.dto.message.Message;
import cn.blankcat.openapi.v1.Resource;
import retrofit2.Call;
import retrofit2.http.*;

import java.util.Map;

public interface MessageReactionService{

    // CreateMessageReaction 对消息发表表情表态
    @PUT(Resource.messageReactionURI)
    Call<String> createMessageReaction(@Path("channel_id") String channelId,
                                       @Path("message_id") String messageId,
                                       @Path("emoji_type") Integer emojiType,
                                       @Path("emoji_id") String emojiId);

    // DeleteOwnMessageReaction 删除自己的消息表情表态
    @DELETE(Resource.messageReactionURI)
    Call<String> deleteOwnMessageReaction(@Path("channel_id") String channelId,
                                          @Path("message_id") String messageId,
                                          @Path("emoji_type") Integer emojiType,
                                          @Path("emoji_id") String emojiId);

    // GetMessageReactionUsers 获取消息表情表态用户列表
    @GET(Resource.messageReactionURI)
    Call<Message> getMessageReactionUsers(@Path("channel_id") String channelId,
                                          @Path("message_id") String messageId,
                                          @Path("emoji_type") Integer emojiType,
                                          @Path("emoji_id") String emojiId,
                                          @QueryMap Map<String,String> pager);


}
