package cn.blankcat.openapi.v1.service;

import cn.blankcat.dto.audio.AudioControl;
import cn.blankcat.dto.channel.Channel;
import cn.blankcat.openapi.v1.Resource;
import retrofit2.Call;
import retrofit2.http.*;

public interface AudioService{

    // PostAudio AudioAPI 接口实现
    @POST(Resource.audioControlURI)
    Call<Channel> postAudio(@Path("channel_id") String channelId,
                            @Body AudioControl audioControl);

    // PutMic 上麦接口实现
    @PUT(Resource.micURI)
    Call<String> putMic(@Path("channel_id") String channelId);


    // DeleteMic 上麦接口实现
    @DELETE(Resource.micURI)
    Call<String> deleteMic(@Path("channel_id") String channelId);

}
