package cn.blankcat.openapi.v1;

public class Resource {
    public static final String domain = "api.sgroup.qq.com";
    public static final String sandBoxDomain = "sandbox.api.sgroup.qq.com";
    public static final String scheme = "https";

    public static final String guildURI = "/guilds/{guild_id}";
    public static final String guildMembersURI= "/guilds/{guild_id}/members";
    public static final String guildMemberURI = "/guilds/{guild_id}/members/{user_id}";
    public static final String guildRoleMemberURI = "/guilds/{guild_id}/roles/{role_id}/members";
    // 频道禁言
    public static final String guildMuteURI = "/guilds/{guild_id}/mute";
    // 频道指定成员禁言
    public static final String guildMembersMuteURI = "/guilds/{guild_id}/members/{user_id}/mute";

    public static final String channelsURI = "/guilds/{guild_id}/channels";
    public static final String channelURI = "/channels/{channel_id}";

    public static final String channelPermissionsURI = "/channels/{channel_id}/members/{user_id}/permissions";
    public static final String channelRolesPermissionsURI = "/channels/{channel_id}/roles/{role_id}/permissions";

    public static final String messagesURI = "/channels/{channel_id}/messages";
    public static final String messageURI = "/channels/{channel_id}/messages/{message_id}";

    public static final String userMeURI = "/users/@me";
    public static final String userMeGuildsURI = "/users/@me/guilds";
    public static final String userMeDMURI = "/users/@me/dms";

    // nolint
    public static final String gatewayURI = "/gateway";
    public static final String gatewayBotURI = "/gateway/bot";

    public static final String audioControlURI = "/channels/{channel_id}/audio";
    public static final String micURI = "/channels/{channel_id}/mic";

    public static final String rolesURI = "/guilds/{guild_id}/roles";
    public static final String roleURI = "/guilds/{guild_id}/roles/{role_id}";

    public static final String memberRoleURI = "/guilds/{guild_id}/members/{user_id}/roles/{role_id}";

    public static final String dmsURI = "/dms/{guild_id}/messages";
    public static final String dmsMessageURI = "/dms/{guild_id}/messages/{message_id}";

    public static final String channelAnnouncesURI = "/channels/{channel_id}/announces";
    public static final String channelAnnounceURI = "/channels/{channel_id}/announces/{message_id}";
    public static final String channelAnnounceURIAll = "/channels/{channel_id}/announces/all";

    public static final String guildAnnouncesURI = "/guilds/{guild_id}/announces";
    public static final String guildAnnounceURI = "/guilds/{guild_id}/announces/{message_id}";
    public static final String guildAnnounceURIAll = "/guilds/{guild_id}/announces/all";

    public static final String schedulesURI = "/channels/{channel_id}/schedules";
    public static final String scheduleURI = "/channels/{channel_id}/schedules/{schedule_id}";

    public static final String apiPermissionURI = "/guilds/{guild_id}/api_permission";
    public static final String apiPermissionDemandURI = "/guilds/{guild_id}/api_permission/demand";

    public static final String pinsURI = "/channels/{channel_id}/pins";
    public static final String pinURI = "/channels/{channel_id}/pins/{message_id}";
    public static final String pinURIAll = "/channels/{channel_id}/pins/all";

    public static final String messageReactionURI = "/channels/{channel_id}/messages/{message_id}/reactions/{emoji_type}/{emoji_id}";

    public static final String interactionsURI = "/interactions/{interaction_id}";

    public static final String httpSessionsURI = "/gateway/webhook/sessions";
    public static final String httpSessionsURICheck = "/gateway/webhook/sessions?action=check";
    public static final String httpSessionURI = "/gateway/webhook/sessions/{session_id}";

    public static final String messageSettingURI = "/guilds/{guild_id}/message/setting";

    public static final String voiceChannelMembersURI = "/channels/{channel_id}/voice/members";

    public static final String settingGuideURI = "/channels/{channel_id}/settingguide";
    public static final String dmSettingGuideURI = "/dms/{guild_id}/settingguide";

    public static String getDomain(Boolean inSandbox){
        String d = domain;
        if (inSandbox){
            d = sandBoxDomain;
        }
        return scheme + "://"+ d;
    }
}
