package cn.blankcat.openapi.v1;

import cn.blankcat.token.Token;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import retrofit2.Retrofit;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class OpenApiData {

    private Token token;
    // MaxIdleConns 默认指定空闲连接池大小
    private Integer maxIdleConns;
    private Long version;
    private Integer timeout;
    // 请求沙箱环境
    private Boolean inSandBox ;
    // debug 模式，调试sdk时候使用
    private Boolean debug ;
    // lastTraceID id
    private String lastTraceID;
    // Retrofit client 复用
    private Retrofit restyClient;

}
