package cn.blankcat.err;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

// Err sdk err
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class Err {

    private int code;
    private String text;
    // 错误追踪ID，可用于向平台反馈问题
    private String trace;

    public String out(){
        return "code:" + this.code + ", text:" + this.text + ", traceID:" + this.trace;
    }

    // New 创建一个新错误
    public static Err newErr(int code, String text, String ...traces){
        Err err = new Err(code, text, "");
        if (traces.length > 0){
            err.trace = traces[0];
        }
        return err;
    }

    public static Err exceptionToErr(Exception e){
        return new Err(9999, e.getMessage(), "");
    }

}
