package cn.blankcat.dto.websocket;

import cn.blankcat.dto.audio.AudioAction;
import cn.blankcat.dto.channel.Channel;
import cn.blankcat.dto.forum.ForumAuditResult;
import cn.blankcat.dto.forum.Post;
import cn.blankcat.dto.forum.Reply;
import cn.blankcat.dto.forum.Thread;
import cn.blankcat.dto.guild.Guild;
import cn.blankcat.dto.interaction.Interaction;
import cn.blankcat.dto.member.Member;
import cn.blankcat.dto.message.Message;
import cn.blankcat.dto.message.MessageAudit;
import cn.blankcat.dto.message.MessageDelete;

import java.util.HashMap;
import java.util.Map;

public class WSEvent {

    public static Map<Intent, WSEventType[]> intentEventMap;
    public static Map<WSEventType, Intent> eventIntentMap;
    public static Map<WSEventType, Class<?>> eventClassMap;

    static {
        intentEventMap = new HashMap<>();
        eventIntentMap = new HashMap<>();
        eventClassMap = new HashMap<>();
        intentEventMap.put(Intent.IntentGuilds, new WSEventType[]{WSEventType.EventGuildCreate, WSEventType.EventGuildUpdate, WSEventType.EventGuildDelete, WSEventType.EventChannelCreate, WSEventType.EventChannelUpdate, WSEventType.EventChannelDelete});
        intentEventMap.put(Intent.IntentGuildMembers, new WSEventType[]{WSEventType.EventGuildMemberAdd, WSEventType.EventGuildMemberUpdate, WSEventType.EventGuildMemberRemove});
        intentEventMap.put(Intent.IntentGuildMessages, new WSEventType[]{WSEventType.EventMessageCreate,WSEventType.EventMessageDelete});
        intentEventMap.put(Intent.IntentGuildAtMessage, new WSEventType[]{WSEventType.EventAtMessageCreate,WSEventType.EventPublicMessageDelete});
        intentEventMap.put(Intent.IntentDirectMessages, new WSEventType[]{WSEventType.EventDirectMessageCreate,WSEventType.EventDirectMessageDelete});
        intentEventMap.put(Intent.IntentAudio, new WSEventType[]{WSEventType.EventAudioStart, WSEventType.EventAudioFinish, WSEventType.EventAudioOnMic, WSEventType.EventAudioOffMic});
        intentEventMap.put(Intent.IntentAudit, new WSEventType[]{WSEventType.EventMessageAuditPass, WSEventType.EventMessageAuditReject});
        intentEventMap.put(Intent.IntentForum, new WSEventType[]{WSEventType.EventForumThreadCreate, WSEventType.EventForumThreadUpdate, WSEventType.EventForumThreadDelete, WSEventType.EventForumPostCreate, WSEventType.EventForumPostDelete, WSEventType.EventForumReplyCreate, WSEventType.EventForumReplyDelete, WSEventType.EventForumAuditResult});
        intentEventMap.put(Intent.IntentInteraction, new WSEventType[]{WSEventType.EventInteractionCreate});

        eventClassMap.put(WSEventType.EventGuildCreate, Guild.class);
        eventClassMap.put(WSEventType.EventGuildUpdate, Guild.class);
        eventClassMap.put(WSEventType.EventGuildDelete, Guild.class);
        eventClassMap.put(WSEventType.EventChannelCreate, Channel.class);
        eventClassMap.put(WSEventType.EventChannelUpdate, Channel.class);
        eventClassMap.put(WSEventType.EventChannelDelete, Channel.class);
        eventClassMap.put(WSEventType.EventGuildMemberAdd, Member.class);
        eventClassMap.put(WSEventType.EventGuildMemberUpdate, Member.class);
        eventClassMap.put(WSEventType.EventGuildMemberRemove, Member.class);
        eventClassMap.put(WSEventType.EventMessageCreate, Message.class);
        eventClassMap.put(WSEventType.EventMessageDelete, MessageDelete.class);
        eventClassMap.put(WSEventType.EventAtMessageCreate, Message.class);
        eventClassMap.put(WSEventType.EventPublicMessageDelete, MessageDelete.class);
        eventClassMap.put(WSEventType.EventDirectMessageCreate, Message.class);
        eventClassMap.put(WSEventType.EventDirectMessageDelete, MessageDelete.class);
        eventClassMap.put(WSEventType.EventAudioStart, AudioAction.class);
        eventClassMap.put(WSEventType.EventAudioFinish, AudioAction.class);
        eventClassMap.put(WSEventType.EventAudioOnMic, AudioAction.class);
        eventClassMap.put(WSEventType.EventAudioOffMic, AudioAction.class);
        eventClassMap.put(WSEventType.EventMessageAuditPass, MessageAudit.class);
        eventClassMap.put(WSEventType.EventMessageAuditReject, MessageAudit.class);
        eventClassMap.put(WSEventType.EventForumThreadCreate, Thread.class);
        eventClassMap.put(WSEventType.EventForumThreadUpdate, Thread.class);
        eventClassMap.put(WSEventType.EventForumThreadDelete, Thread.class);
        eventClassMap.put(WSEventType.EventForumPostCreate, Post.class);
        eventClassMap.put(WSEventType.EventForumPostDelete, Post.class);
        eventClassMap.put(WSEventType.EventForumReplyCreate, Reply.class);
        eventClassMap.put(WSEventType.EventForumReplyDelete, Reply.class);
        eventClassMap.put(WSEventType.EventForumAuditResult, ForumAuditResult.class);
        eventClassMap.put(WSEventType.EventInteractionCreate, Interaction.class);
        eventClassMap.put(WSEventType.TypeReady, WSReadyData.class);
        eventClassMap.put(WSEventType.TypeResumed, WSPayload.class);


        eventIntentMap = transposeIntentEventMap(intentEventMap);
    }

    public static Map<WSEventType, Intent> transposeIntentEventMap(Map<Intent, WSEventType[]> intentEventMap){
        Map<WSEventType, Intent> result = new HashMap<>();
        for (Intent intent : intentEventMap.keySet()) {
            for (WSEventType wsEventType : intentEventMap.get(intent)) {
                result.put(wsEventType, intent);
            }
        }
        return result;
    }

    public static int eventToIntent(WSEventType ...wsEventTypes){
        int i = 0;
        for (WSEventType wsEventType : wsEventTypes) {
            Intent intent = eventIntentMap.get(wsEventType);
            if (intent != null){
                i = i | intent.getValue();
            }
        }
        return i;
    }

    public static int allEventToIntent(){
        int i = 0;
        i = i | Intent.IntentGuilds.getValue();
        i = i | Intent.IntentGuildMembers.getValue();
        i = i | Intent.IntentGuildMessages.getValue();
        i = i | Intent.IntentGuildAtMessage.getValue();
        i = i | Intent.IntentDirectMessages.getValue();
        i = i | Intent.IntentAudio.getValue();
        i = i | Intent.IntentAudit.getValue();
        i = i | Intent.IntentForum.getValue();
        i = i | Intent.IntentInteraction.getValue();
        return i;
    }

}
