package cn.blankcat.dto.websocket;

import cn.blankcat.token.Token;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// Session 连接的 session 结构，包括链接的所有必要字段
public class Session {

    // Intent 类型


    private String id;
    private String url;
    private Token token;
    private int intent;
    private long lastSeq;
    private ShardConfig shards;

    public String getBetterSession(){
        return "[ws][ID:"+ id +"][Shard:("+ shards.getShardID() + "/" + shards.getShardCount() +")][Intent:"+ intent +"]";
    }
}
