package cn.blankcat.dto.schedule;

import cn.blankcat.dto.member.Member;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

// Schedule 日程对象
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class Schedule {

    private String id;
    private String name;
    private String description;
    @JsonProperty("start_timestamp")
    private String startTimestamp;
    @JsonProperty("end_timestamp")
    private String endTimestamp;
    @JsonProperty("jump_channel_id")
    private String jumpChannelId;
    @JsonProperty("remind_type")
    private String remindType;
    private Member creator;
}
