package cn.blankcat.dto.role;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// Role 频道身份组
public class Role {

    public static final long DEFAULT_COLOR = 4278245297L;

    private String id;
    private String name;
    private long color;
    private long hoist;
    // 不会被修改，创建接口修改
    @JsonProperty("number")
    private long memberCount;
    // 不会被修改，创建接口修改
    @JsonProperty("member_limit")
    private long memberLimit;
}
