package cn.blankcat.dto.permission;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

// APIPermissionDemand 接口权限需求对象
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class APIPermissionDemand {

    // 频道 ID
    @JsonProperty("guild_id")
    private String guildId;
    // 子频道 ID
    @JsonProperty("channel_id")
    private String channelId;
    // 权限接口唯一标识
    @JsonProperty("api_identify")
    private APIPermissionDemandIdentify APIIdentify;
    // 接口权限链接中的接口权限描述信息
    private String title;
    // 接口权限链接中的机器人可使用功能的描述信息
    private String desc;
}
