package cn.blankcat.dto.permission;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class APIPermission {

    // API 接口名，例如 /guilds/{guild_id}/members/{user_id}
    private String path;
    // 请求方法，例如 GET
    private String method;
    // API 接口名称，例如 获取频道信息
    private String desc;
    // 授权状态，auth_stats 为 1 时已授权
    @JsonProperty("auth_status")
    private String authStatus;

}
