package cn.blankcat.dto.pager;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.HashMap;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// GuildRoleMembersPager 分页器
public class GuildRoleMembersPager implements Pager{

    public static GuildRoleMembersPager defaultPager = new GuildRoleMembersPager("", "10");

    @JsonProperty("start_index")
    private String startIndex;
    private String limit;

    @Override
    public Map<String, String> QueryParams() {
        HashMap<String,String> query = new HashMap<>();
        if (!"".equals(this.limit)){
            query.put("limit", this.limit);
        }
        if (!"".equals(this.startIndex)){
            query.put("start_index", this.startIndex);
        }
        return query;
    }
    
}
