package cn.blankcat.dto.mute;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

// UpdateGuildMute 更新频道相关禁言的Body参数
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class UpdateGuildMute {

    // 禁言截止时间戳，单位秒
    @JsonProperty("mute_end_timestamp")
    private String muteEndTimestamp;
    // 禁言多少秒（两个字段二选一，默认以mute_end_timstamp为准）
    @JsonProperty("mute_seconds")
    private String muteSeconds;
    // 批量禁言的成员列表（全员禁言时不填写该字段）
    @JsonProperty("user_ids")
    private String[] userIds;
}
