package cn.blankcat.dto.member;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// Member 群成员
public class User {

    private String id;
    private String username;
    private String avatar;
    private Boolean bot;
    // 特殊关联应用的 openid
    @JsonProperty("union_openid")
    private String unionOpenId;
    // 机器人关联的用户信息，与union_openid关联的应用是同一个
    @JsonProperty("union_user_account")
    private String unionUserAccount;

}
