package cn.blankcat.dto.member;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.function.Function;

// MemberDeleteOpts 删除成员额外参数
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class MemberDeleteOpts {

    // DeleteHistoryMsgDay 消息撤回天数
    // 支持的消息撤回天数，除这些天数之外，传递其他值将不会撤回任何消息
    public enum DeleteHistoryMsgDay {
        NO_DELETE(0),             // 不删除任何消息
        DELETE_THREE_DAYS(3),     // 3天
        DELETE_SEVEN_DAYS(7),     // 7天
        DELETE_FIFTEEN_DAYS(15),  // 15天
        DELETE_THIRTY_DAYS(30),   // 30天
        DELETE_ALL(-1);           // 删除所有消息

        private final int value;

        DeleteHistoryMsgDay(int value) {
            this.value = value;
        }

        @JsonValue
        public int getValue() {
            return value;
        }
    }

    @JsonProperty("add_blacklist")
    private Boolean addBlackList;
    @JsonProperty("delete_history_msg_days")
    private DeleteHistoryMsgDay deleteHistoryMsgDays;

    // WithAddBlackList 将当前成员同时添加到频道黑名单中
    public static Function<MemberDeleteOpts, Void> WithAddBlackList(Boolean b){
        return (o)-> {
            o.addBlackList = b;
            return null;
        };
    }

    // WithDeleteHistoryMsg 删除成员时同时撤回消息
    public static Function<MemberDeleteOpts, Void> WithDeleteHistoryMsg(DeleteHistoryMsgDay days){
        return (o)-> {
            o.deleteHistoryMsgDays = days;
            return null;
        };
    }
}
