package cn.blankcat.dto.interaction;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// SearchLayout 搜索结果的布局
public class SearchLayout {

    // LayoutType 布局类型
    public enum LayoutType{
        // LayoutTypeImageText 左图右文
        LAYOUT_TYPE_IMAGE_TEXT(0);
        private final int value;
        LayoutType(int value){
            this.value = value;
        }
        @JsonValue
        public int getValue(){
            return value;
        }
    }

    // ActionType 每行数据的点击行为
    public enum ActionType{
        // ActionTypeSendARK 发送 ark 消息
        ACTION_TYPE_SEND_ARK(0);
        private final int value;
        ActionType(int value){
            this.value = value;
        }
        @JsonValue
        public int getValue(){
            return value;
        }
    }

    private LayoutType layoutType;
    private ActionType actionType;
    private String title;
    private List<SearchRecord> records;

}
