package cn.blankcat.dto.guild;

import cn.blankcat.dto.channel.Channel;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
// Guild 频道结构定义
public class Guild {

    public static final Guild EMPTY = new Guild();

    // 频道ID（与客户端上看到的频道ID不同）
    private String id;
    // 频道名称
    private String name;
    // 频道头像
    private String icon;
    // 拥有者ID
    @JsonProperty("owner_id")
    private String ownerId;
    // 是否为拥有者
    private Boolean owner;
    // 成员数量
    @JsonProperty("member_count")
    private int memberCount;
    // 最大成员数目
    @JsonProperty("max_members")
    private long maxMembers;
    // 频道描述
    @JsonProperty("description")
    private String desc;
    // 当前用户加入群的时间
    // 此字段只在GUILD_CREATE事件中使用
    @JsonProperty("joined_at")
    private String joinedAt;
    // 频道列表
    private List<Channel> channels;
    // 游戏绑定公会区服ID
    @JsonProperty("union_world_id")
    private String unionWorldId;
    // 游戏绑定公会/战队ID
    @JsonProperty("union_org_id")
    private String unionOrgId;
    @JsonProperty("op_user_id")
    private String OpUserId;
}
