package cn.blankcat.dto.gateway;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class HTTPSession {

    @JsonProperty("app_id")
    private long appId;
    @JsonProperty("session_id")
    private String sessionId;
    @JsonProperty("callback_url")
    private String callbackURL;
    private String env;
    private String intents;
    @JsonProperty("last_heartbeat_time")
    private String lastHeartbeatTime;
    private String state;
    private long[] shards;
}
