package cn.blankcat.dto.audio;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class AudioControl {

    // 音频状态
    public enum AudioStatus{
        AUDIO_STATUS_START(0),
        AUDIO_STATUS_PAUSE(1),
        AUDIO_STATUS_RESUME(2),
        AUDIO_STATUS_STOP(3);
        private final long value;
        AudioStatus(long value){
            this.value = value;
        }
        @JsonValue
        public long getValue(){
            return value;
        }
    }

    // AudioControl 音频控制对象
    @JsonProperty("audio_url")
    private String url;
    private String text;
    @JsonProperty("status")
    private AudioStatus audioStatus;
}
