/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.websocket.v1.service;

import cn.blankcat.dto.audio.AudioAction;
import cn.blankcat.dto.channel.Channel;
import cn.blankcat.dto.forum.ForumAuditResult;
import cn.blankcat.dto.forum.Post;
import cn.blankcat.dto.forum.Reply;
import cn.blankcat.dto.forum.Thread;
import cn.blankcat.dto.guild.Guild;
import cn.blankcat.dto.interaction.Interaction;
import cn.blankcat.dto.member.Member;
import cn.blankcat.dto.message.Message;
import cn.blankcat.dto.message.MessageAudit;
import cn.blankcat.dto.message.MessageDelete;
import cn.blankcat.dto.websocket.Intent;
import cn.blankcat.dto.websocket.Session;
import cn.blankcat.dto.websocket.WSEvent;
import cn.blankcat.dto.websocket.WSEventType;
import cn.blankcat.dto.websocket.WSHelloData;
import cn.blankcat.dto.websocket.WSIdentityData;
import cn.blankcat.dto.websocket.WSOPCode;
import cn.blankcat.dto.websocket.WSPayload;
import cn.blankcat.dto.websocket.WSReadyData;
import cn.blankcat.dto.websocket.WSResumeData;
import cn.blankcat.websocket.v1.WebsocketApi;
import cn.blankcat.websocket.v1.WebsocketApiData;
import cn.blankcat.websocket.v1.handler.AbstractWebsocketHandler;
import cn.blankcat.websocket.v1.handler.ReadyHandler;
import cn.blankcat.websocket.v1.handler.WebsocketHandler;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketService
implements WebsocketApi {
    private static final Logger logger = LoggerFactory.getLogger((String)"WebsocketService");
    public static final Map<Class<?>, List<AbstractWebsocketHandler<?>>> handlers = new HashMap();
    private final WebsocketApiData websocketApiData = new WebsocketApiData();
    private final ExecutorService fixedThreadPool = Executors.newFixedThreadPool(3);

    public WebsocketApiData getWebsocketApiData() {
        return this.websocketApiData;
    }

    private void websocketEventDispatcher(String text) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            WSEventType wsEventType;
            Class<?> clazz;
            WSPayload wsPayload = (WSPayload)mapper.readValue(text, WSPayload.class);
            if (wsPayload.getSeq() > 0L) {
                this.session().setLastSeq(wsPayload.getSeq());
            }
            if ((clazz = WSEvent.eventClassMap.get((Object)(wsEventType = WSEventType.ofValue(wsPayload.getType())))) == null) {
                this.buildInHandler(wsPayload);
            } else {
                for (WebsocketHandler websocketHandler : handlers.get(clazz)) {
                    websocketHandler.handle(text, this);
                }
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private void buildInHandler(WSPayload payload) throws JsonProcessingException {
        WSOPCode wsOPCode = WSOPCode.ofValue(payload.getOpCode());
        switch (wsOPCode) {
            case WSHello: {
                this.fixedThreadPool.execute(() -> {
                    Object obj = payload.getData();
                    WSHelloData helloData = (WSHelloData)mapper.convertValue(obj, WSHelloData.class);
                    this.keepHeart(helloData.getHeartbeatInterval());
                });
                break;
            }
            case WSHeartbeatAck: {
                break;
            }
            case WSReconnect: {
                this.resume();
                break;
            }
            case WSInvalidSession: {
                this.identify();
            }
        }
    }

    private void keepHeart(int period) {
        logger.info("\u542f\u52a8\u5fc3\u8df3\u8fdb\u7a0b\u6210\u529f,\u5373\u5c06\u4ee5{}ms\u7684\u95f4\u9694\u53d1\u9001\u5fc3\u8df3...", (Object)((long)period * 4L / 5L));
        this.websocketApiData.getHeartBeatTicker().schedule(new TimerTask(){

            @Override
            public void run() {
                WSPayload wsPayload = new WSPayload();
                wsPayload.setOpCode(WSOPCode.WSHeartbeat.getValue());
                wsPayload.setData(WebsocketService.this.session().getLastSeq());
                WebsocketService.this.write(wsPayload);
            }
        }, 1000L, (long)period * 4L / 5L);
    }

    private void setupWebsocketClient(Session session) {
        OkHttpClient httpClient = new OkHttpClient.Builder().readTimeout(3L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).connectTimeout(3L, TimeUnit.SECONDS).build();
        WebSocket websocket = httpClient.newWebSocket(new Request.Builder().get().url(session.getUrl()).build(), (WebSocketListener)new MyWebSocketListener());
        this.websocketApiData.setConn(websocket);
    }

    public WebsocketApi init(Session session) {
        this.websocketApiData.setSession(session);
        this.websocketApiData.setHeartBeatTicker(new Timer());
        this.setupWebsocketClient(session);
        return this;
    }

    @Override
    public void connect() {
        this.fixedThreadPool.execute(() -> this.keepHeart(41250));
    }

    @Override
    public boolean identify() {
        Session session = this.session();
        if (session.getIntent() == Intent.IntentNone.getValue()) {
            session.setIntent(Intent.IntentGuilds.getValue());
        }
        WSIdentityData data = new WSIdentityData();
        data.setToken(session.getToken().getRealString());
        data.setIntents(session.getIntent());
        Long[] shard = new Long[]{session.getShards().getShardID(), session.getShards().getShardCount()};
        data.setShard(shard);
        WSPayload<WSIdentityData> payload = new WSPayload<WSIdentityData>(data);
        payload.setData(data);
        payload.setOpCode(WSOPCode.WSIdentity.getValue());
        payload.setType("");
        logger.info("\u6b63\u5728\u8fdb\u884c\u9274\u6743...");
        return this.write(payload);
    }

    @Override
    public Session session() {
        return this.websocketApiData.getSession();
    }

    @Override
    public boolean resume() {
        Session session = this.session();
        WSResumeData data = new WSResumeData();
        data.setToken(session.getToken().getRealString());
        data.setSessionId(session.getId());
        data.setSeq(session.getLastSeq());
        WSPayload<WSResumeData> payload = new WSPayload<WSResumeData>(data);
        payload.setData(data);
        payload.setOpCode(WSOPCode.WSResume.getValue());
        payload.setType("");
        logger.info("\u6b63\u5728\u6062\u590d\u8fde\u63a5...");
        return this.write(payload);
    }

    @Override
    public boolean write(WSPayload payload) {
        try {
            String json = mapper.writeValueAsString((Object)payload);
            boolean send = this.websocketApiData.getConn().send(json);
            logger.info("{}(session)\u5199\u5165[{}]\u4fe1\u606f:{}", new Object[]{this.websocketApiData.getSession().getId(), WSOPCode.ofValue(payload.getOpCode()), json});
            return send;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean close() {
        return this.websocketApiData.getConn().close(100, null);
    }

    static {
        handlers.put(Guild.class, new ArrayList());
        handlers.put(Message.class, new ArrayList());
        handlers.put(MessageDelete.class, new ArrayList());
        handlers.put(MessageAudit.class, new ArrayList());
        handlers.put(Channel.class, new ArrayList());
        handlers.put(Member.class, new ArrayList());
        handlers.put(AudioAction.class, new ArrayList());
        handlers.put(Thread.class, new ArrayList());
        handlers.put(Post.class, new ArrayList());
        handlers.put(Reply.class, new ArrayList());
        handlers.put(ForumAuditResult.class, new ArrayList());
        handlers.put(Interaction.class, new ArrayList());
        handlers.put(WSReadyData.class, new ArrayList());
        handlers.put(WSHelloData.class, new ArrayList());
        handlers.put(WSPayload.class, new ArrayList());
        new ReadyHandler().registry();
    }

    private class MyWebSocketListener
    extends WebSocketListener {
        private MyWebSocketListener() {
        }

        public void onOpen(WebSocket webSocket, Response response) {
            super.onOpen(webSocket, response);
        }

        public void onMessage(WebSocket webSocket, String text) {
            WebsocketService.this.websocketEventDispatcher(text);
            super.onMessage(webSocket, text);
        }

        public void onMessage(WebSocket webSocket, ByteString bytes) {
            super.onMessage(webSocket, bytes);
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
            super.onClosing(webSocket, code, reason);
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            super.onClosed(webSocket, code, reason);
        }

        public void onFailure(WebSocket webSocket, Throwable t, @Nullable Response response) {
            if (response != null && response.body() != null) {
                MediaType mediaType = response.body().contentType();
                try {
                    String responseString = response.body().string();
                    if (response.code() > 209) {
                        logger.warn("\u8bf7\u6c42\u9519\u8bef, \u9519\u8bef\u5185\u5bb9\u4e3a:{}", (Object)responseString);
                    }
                    super.onFailure(webSocket, t, response.newBuilder().body(ResponseBody.create((MediaType)mediaType, (String)responseString)).build());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

