/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.websocket.v1.handler;

import cn.blankcat.dto.websocket.WSPayload;
import cn.blankcat.websocket.v1.handler.WebsocketHandler;
import cn.blankcat.websocket.v1.service.WebsocketService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebsocketHandler<T>
implements WebsocketHandler {
    protected static final Logger logger = LoggerFactory.getLogger((String)"websocketHandler");
    protected final ObjectMapper mapper = new ObjectMapper();
    protected Class<T> clazz;

    public void registry() {
        WebsocketService.handlers.get(this.getActualType()).add(this);
        logger.info("\u5df2\u5728{}\u4e2d\u6ce8\u518chandler-------->{}", (Object)this.clazz.getSimpleName(), (Object)this.getClass().getSimpleName());
    }

    public Class<T> getActualType() {
        if (this.clazz == null) {
            Type superclass = this.getClass().getGenericSuperclass();
            if (superclass instanceof ParameterizedType && ((ParameterizedType)superclass).getRawType().equals(AbstractWebsocketHandler.class)) {
                Type actualTypeArgument = ((ParameterizedType)superclass).getActualTypeArguments()[0];
                this.clazz = (Class)actualTypeArgument;
            }
            if (this.clazz == null) {
                logger.error("{} \u6ca1\u6709\u83b7\u53d6\u5230\u6cdb\u578b\u7c7b\u578b, \u8bf7\u4e3aWebsocketHandler\u6307\u5b9a\u4e00\u4e2a\u6cdb\u578b\u7528\u4e8e\u6d88\u606fData\u7684\u8f6c\u6362", (Object)this.getClass().getName());
            }
        }
        return this.clazz;
    }

    public T getPayloadData(String message) {
        this.getActualType();
        try {
            WSPayload payload = (WSPayload)this.mapper.readValue(message, this.mapper.getTypeFactory().constructParametricType(WSPayload.class, new Class[]{this.clazz}));
            Object obj = payload.getData();
            return (T)this.mapper.convertValue(obj, this.clazz);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

