/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.websocket.v1;

import cn.blankcat.dto.websocket.Session;
import cn.blankcat.dto.websocket.ShardConfig;
import cn.blankcat.dto.websocket.WSEvent;
import cn.blankcat.dto.websocket.WebsocketAP;
import cn.blankcat.openapi.v1.OpenApi;
import cn.blankcat.openapi.v1.service.WsService;
import cn.blankcat.token.Token;
import cn.blankcat.websocket.v1.WebsocketApi;
import cn.blankcat.websocket.v1.service.WebsocketService;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Retrofit;

public class WebsocketManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"WebsocketManager");
    private static final ExecutorService threadPool = Executors.newCachedThreadPool();
    private static final long concurrencyTimeWindowSec = 2L;

    public void run() {
        this.run(null, false, 3);
    }

    public void run(Token token, Boolean inSandbox, Integer timeout) {
        try {
            Retrofit restyClient = OpenApi.getClient(token, inSandbox, timeout);
            WebsocketAP apiInfo = (WebsocketAP)((WsService)restyClient.create(WsService.class)).ws().execute().body();
            if (apiInfo == null) {
                logger.error("websocket\u914d\u7f6e\u4fe1\u606f\u83b7\u53d6\u5931\u8d25...");
                return;
            }
            this.start(apiInfo, OpenApi.getData().getToken(), WSEvent.allEventToIntent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void start(WebsocketAP apiInfo, Token token, int intents) {
        long startInterval = this.calcInterval(apiInfo.getSessionStartLimit().getMaxConcurrency());
        logger.info("\u5373\u5c06\u4ee5{}s\u6bcf\u4e2a\u7684\u95f4\u9694\u542f\u52a8{}\u4e2asessions...", (Object)startInterval, (Object)apiInfo.getShards());
        int i = 0;
        while ((long)i < apiInfo.getShards()) {
            ShardConfig shards = new ShardConfig();
            shards.setShardID(i);
            shards.setShardCount(apiInfo.getShards());
            Session session = new Session();
            session.setId("");
            session.setUrl(apiInfo.getUrl());
            session.setToken(token);
            session.setIntent(intents);
            session.setLastSeq(0L);
            session.setShards(shards);
            threadPool.execute(() -> this.newConnect(session));
            ++i;
        }
    }

    private long calcInterval(long maxConcurrency) {
        int i;
        if (maxConcurrency == 0L) {
            maxConcurrency = 1L;
        }
        return (i = Math.round(2.0f / (float)maxConcurrency)) <= 0 ? 1L : (long)i;
    }

    private boolean newConnect(Session session) {
        WebsocketApi wsApi = new WebsocketService().init(session);
        if (!"".equals(session.getId())) {
            if (!wsApi.resume()) {
                Session currentSession = wsApi.session();
                currentSession.setId("");
                currentSession.setLastSeq(0L);
                return false;
            }
        } else if (!wsApi.identify()) {
            logger.error("\u9274\u6743\u5931\u8d25\uff0c\u8fdb\u7a0b\u9000\u51fa...");
            return false;
        }
        return true;
    }
}

