/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.token;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Token {
    private static final Logger logger = LoggerFactory.getLogger((String)"token");
    public static final Token EMPTY = new Token();
    private long appId;
    private String accessToken;
    private Type type;

    public String getRealString() {
        if (this.type == Type.TYPE_NORMAL) {
            return this.type.value + " " + this.accessToken;
        }
        return this.type.value + " " + this.appId + "." + this.accessToken;
    }

    public static Token BotToken(long appId, String accessToken) {
        Token token = new Token();
        token.appId = appId;
        token.accessToken = accessToken;
        token.type = Type.TYPE_BOT;
        return token;
    }

    public static Token UserToken(long appId, String accessToken) {
        Token token = new Token();
        token.appId = appId;
        token.accessToken = accessToken;
        token.type = Type.TYPE_NORMAL;
        return token;
    }

    public static Token loadFromConfig(String filePath, Type tokenType) {
        if (filePath == null || filePath.isEmpty()) {
            filePath = "bot.yaml";
        }
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        InputStream inputStream = Token.class.getClassLoader().getResourceAsStream(filePath);
        mapper.findAndRegisterModules();
        try {
            Token token = (Token)mapper.readValue(inputStream, Token.class);
            if (token.getAccessToken().isEmpty() || token.getAccessToken().isBlank()) {
                logger.warn("error read token from file ");
            }
            if (token.getAppId() == 0L) {
                logger.warn("error read appid from file ");
            }
            token.type = tokenType;
            return token;
        }
        catch (IOException e) {
            e.printStackTrace();
            return EMPTY;
        }
    }

    public long getAppId() {
        return this.appId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Type getType() {
        return this.type;
    }

    public void setAppId(long appId) {
        this.appId = appId;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token other = (Token)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAppId() != other.getAppId()) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Token;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $appId = this.getAppId();
        result = result * 59 + (int)($appId >>> 32 ^ $appId);
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "Token(appId=" + this.getAppId() + ", accessToken=" + this.getAccessToken() + ", type=" + this.getType() + ")";
    }

    public Token(long appId, String accessToken, Type type) {
        this.appId = appId;
        this.accessToken = accessToken;
        this.type = type;
    }

    public Token() {
    }

    public static enum Type {
        TYPE_BOT("Bot"),
        TYPE_NORMAL("Bearer");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

