/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.openapi.v1.service;

import cn.blankcat.dto.member.Member;
import cn.blankcat.dto.member.MemberDeleteOpts;
import cn.blankcat.dto.pager.GuildMembersPager;
import cn.blankcat.dto.pager.GuildRoleMembersPager;
import cn.blankcat.dto.role.MemberAddRoleBody;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Arrays;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public interface MemberService {
    @PUT(value="/guilds/{guild_id}/members/{user_id}/roles/{role_id}")
    public Call<String> memberAddRole(@Path(value="guild_id") String var1, @Path(value="role_id") String var2, @Path(value="user_id") String var3, @Body MemberAddRoleBody var4);

    @DELETE(value="/guilds/{guild_id}/members/{user_id}/roles/{role_id}")
    public Call<String> memberDeleteRole(@Path(value="guild_id") String var1, @Path(value="role_id") String var2, @Path(value="user_id") String var3, @Body MemberAddRoleBody var4);

    @GET(value="/guilds/{guild_id}/members/{user_id}")
    public Call<Member> guildMember(@Path(value="guild_id") String var1, @Path(value="user_id") String var2);

    @GET(value="/guilds/{guild_id}/members/{user_id}")
    public Call<Member[]> guildMembers(@Path(value="guild_id") String var1, @QueryMap GuildMembersPager var2);

    @GET(value="/guilds/{guild_id}/roles/{role_id}/members")
    public Call<RoleMembersRsp> guildRoleMembers(@Path(value="guild_id") String var1, @Path(value="role_id") String var2, @QueryMap GuildRoleMembersPager var3);

    @DELETE(value="/guilds/{guild_id}/members/{user_id}")
    public Call<Member> deleteGuildMember(@Path(value="guild_id") String var1, @Path(value="role_id") String var2, @Body MemberDeleteOpts var3);

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RoleMembersRsp {
        private Member[] data;
        private String next;

        public Member[] getData() {
            return this.data;
        }

        public String getNext() {
            return this.next;
        }

        public void setData(Member[] data) {
            this.data = data;
        }

        public void setNext(String next) {
            this.next = next;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RoleMembersRsp)) {
                return false;
            }
            RoleMembersRsp other = (RoleMembersRsp)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getData(), other.getData())) {
                return false;
            }
            String this$next = this.getNext();
            String other$next = other.getNext();
            return !(this$next == null ? other$next != null : !this$next.equals(other$next));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RoleMembersRsp;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getData());
            String $next = this.getNext();
            result = result * 59 + ($next == null ? 43 : $next.hashCode());
            return result;
        }

        public String toString() {
            return "MemberService.RoleMembersRsp(data=" + Arrays.deepToString(this.getData()) + ", next=" + this.getNext() + ")";
        }

        public RoleMembersRsp(Member[] data, String next) {
            this.data = data;
            this.next = next;
        }

        public RoleMembersRsp() {
        }
    }
}

