/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.openapi.v1;

import cn.blankcat.openapi.APIVersion;
import cn.blankcat.openapi.v1.OpenApiData;
import cn.blankcat.openapi.v1.Resource;
import cn.blankcat.token.Token;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class OpenApi {
    private static final Logger logger = LoggerFactory.getLogger((String)"OpenAPI");
    private static final OpenApiData data = new OpenApiData(null, 3000, APIVersion.APIv1, 3, false, false, "", null);

    public static OpenApiData getData() {
        return data;
    }

    public static Retrofit getClient(Token token, Boolean inSandBox, Integer timeout) {
        if (data.getRestyClient() == null) {
            return OpenApi.setup(token, inSandBox, timeout);
        }
        return data.getRestyClient();
    }

    public static Retrofit setup(Token token, Boolean inSandBox, Integer timeout) {
        if (token == null) {
            token = Token.loadFromConfig(null, Token.Type.TYPE_BOT);
        }
        data.setToken(token);
        if (inSandBox != null) {
            data.setInSandBox(inSandBox);
        }
        if (timeout != null) {
            data.setTimeout(timeout);
        }
        data.setRestyClient(new Retrofit.Builder().baseUrl(Resource.getDomain(data.getInSandBox())).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).client(new OkHttpClient.Builder().addInterceptor(chain -> {
            Request request = chain.request().newBuilder().addHeader("Authorization", data.getToken().getRealString()).build();
            return chain.proceed(request);
        }).addInterceptor(chain -> {
            Response response = chain.proceed(chain.request());
            MediaType mediaType = response.body().contentType();
            String responseString = response.body().string();
            if (response.code() > 209) {
                logger.warn("\u8bf7\u6c42\u9519\u8bef, \u9519\u8bef\u5185\u5bb9\u4e3a:{}", (Object)responseString);
            }
            return response.newBuilder().body(ResponseBody.create((MediaType)mediaType, (String)responseString)).build();
        }).readTimeout((long)data.getTimeout().intValue(), TimeUnit.SECONDS).writeTimeout((long)data.getTimeout().intValue(), TimeUnit.SECONDS).connectTimeout((long)data.getTimeout().intValue(), TimeUnit.SECONDS).build()).build());
        return data.getRestyClient();
    }
}

