/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.err;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Err {
    private int code;
    private String text;
    private String trace;

    public String out() {
        return "code:" + this.code + ", text:" + this.text + ", traceID:" + this.trace;
    }

    public static Err newErr(int code, String text, String ... traces) {
        Err err = new Err(code, text, "");
        if (traces.length > 0) {
            err.trace = traces[0];
        }
        return err;
    }

    public static Err exceptionToErr(Exception e) {
        return new Err(9999, e.getMessage(), "");
    }

    public int getCode() {
        return this.code;
    }

    public String getText() {
        return this.text;
    }

    public String getTrace() {
        return this.trace;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTrace(String trace) {
        this.trace = trace;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Err)) {
            return false;
        }
        Err other = (Err)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$trace = this.getTrace();
        String other$trace = other.getTrace();
        return !(this$trace == null ? other$trace != null : !this$trace.equals(other$trace));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Err;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $trace = this.getTrace();
        result = result * 59 + ($trace == null ? 43 : $trace.hashCode());
        return result;
    }

    public String toString() {
        return "Err(code=" + this.getCode() + ", text=" + this.getText() + ", trace=" + this.getTrace() + ")";
    }

    public Err(int code, String text, String trace) {
        this.code = code;
        this.text = text;
        this.trace = trace;
    }

    public Err() {
    }
}

