/*
 * Decompiled with CFR 0.152.
 */
package cn.blankcat.dto.websocket;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WSPayload<T> {
    @JsonProperty(value="op")
    private int opCode;
    @JsonProperty(value="s")
    private long seq;
    @JsonProperty(value="t")
    private String type;
    @JsonProperty(value="d")
    private Object data;
    @JsonProperty(value="-")
    private byte[] rawMessage;

    public WSPayload(T _data) {
        this.data = _data;
    }

    public T getData() {
        return (T)this.data;
    }

    public WSPayload<T> setData(Object data) {
        this.data = data;
        return this;
    }

    public byte[] getRawMessage() {
        return this.rawMessage;
    }

    public WSPayload<T> setRawMessage(byte[] rawMessage) {
        this.rawMessage = rawMessage;
        return this;
    }

    public int getOpCode() {
        return this.opCode;
    }

    public long getSeq() {
        return this.seq;
    }

    public String getType() {
        return this.type;
    }

    @JsonProperty(value="op")
    public void setOpCode(int opCode) {
        this.opCode = opCode;
    }

    @JsonProperty(value="s")
    public void setSeq(long seq) {
        this.seq = seq;
    }

    @JsonProperty(value="t")
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WSPayload)) {
            return false;
        }
        WSPayload other = (WSPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOpCode() != other.getOpCode()) {
            return false;
        }
        if (this.getSeq() != other.getSeq()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        return Arrays.equals(this.getRawMessage(), other.getRawMessage());
    }

    protected boolean canEqual(Object other) {
        return other instanceof WSPayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOpCode();
        long $seq = this.getSeq();
        result = result * 59 + (int)($seq >>> 32 ^ $seq);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        result = result * 59 + Arrays.hashCode(this.getRawMessage());
        return result;
    }

    public String toString() {
        return "WSPayload(opCode=" + this.getOpCode() + ", seq=" + this.getSeq() + ", type=" + this.getType() + ", data=" + this.getData() + ", rawMessage=" + Arrays.toString(this.getRawMessage()) + ")";
    }

    public WSPayload(int opCode, long seq, String type, Object data, byte[] rawMessage) {
        this.opCode = opCode;
        this.seq = seq;
        this.type = type;
        this.data = data;
        this.rawMessage = rawMessage;
    }

    public WSPayload() {
    }
}

