package cn.blankcat.websocket.v1.handler;

import cn.blankcat.dto.websocket.*;
import cn.blankcat.websocket.v1.WebsocketApiData;
import cn.blankcat.websocket.v1.service.WebsocketService;

public class ReadyHandler  extends AbstractWebsocketHandler<WSReadyData>{

    @Override
    public void handle(String message, WebsocketService service) {
        logger.info("收到READY信号，正在更新session...");
        WSReadyData readyData = getPayloadData(message);
        WebsocketApiData data = service.getWebsocketApiData();

        ShardConfig shardConfig = new ShardConfig();
        shardConfig.setShardID(readyData.getShard()[0]);
        shardConfig.setShardCount(readyData.getShard()[1]);

        WSUser wsUser = new WSUser();
        wsUser.setId(readyData.getUser().getId());
        wsUser.setUsername(readyData.getUser().getUsername());
        wsUser.setBot(readyData.getUser().getBot());

        Session session = data.getSession();
        data.setVersion(readyData.getVersion());
        data.setUser(wsUser);
        session.setId(readyData.getSessionID());
        session.setShards(shardConfig);
        logger.info("session更新完毕...");
        logger.info("最新session为:{}", session.getBetterSession());
    }
}
