package cn.blankcat.openapi.v1.service;

import cn.blankcat.dto.pin.PinsMessage;
import cn.blankcat.dto.role.GuildRoles;
import cn.blankcat.dto.role.UpdateResult;
import cn.blankcat.dto.role.UpdateRole;
import cn.blankcat.openapi.v1.Resource;
import retrofit2.Call;
import retrofit2.http.*;

public interface RoleService{

    @GET(Resource.rolesURI)
    Call<GuildRoles> roles(@Path("guild_id") String guildID);

    @POST(Resource.rolesURI)
    Call<UpdateResult> postRole(@Path("guild_id") String guildID,
                                @Body UpdateRole body);

    @PATCH(Resource.roleURI)
    Call<UpdateResult> patchRole(@Path("guild_id") String guildID,
                                 @Path("role_id") String roleID,
                                 @Body UpdateRole body);

    @DELETE(Resource.roleURI)
    Call<PinsMessage> deleteRole(@Path("guild_id") String guildID,
                                 @Path("role_id") String roleID);


}
