package cn.blankcat.openapi.v1.service;

import cn.blankcat.dto.channel.Channel;
import cn.blankcat.dto.channel.ChannelValueObject;
import cn.blankcat.dto.member.Member;
import cn.blankcat.openapi.v1.Resource;
import retrofit2.Call;
import retrofit2.http.*;

public interface ChannelService{

    // Channel 拉取指定子频道信息
    @GET(Resource.channelURI)
    Call<Channel> channel(@Path("channel_id") String channelId);

    // Channels 拉取子频道列表
    @GET(Resource.channelsURI)
    Call<Channel[]> channels(@Path("guild_id") String guildID);

    // PostChannel 创建子频道
    @POST(Resource.channelsURI)
    Call<Channel> postChannel(@Path("guild_id") String guildID,
                              @Body ChannelValueObject value);


    // PatchChannel 修改子频道
    @PATCH(Resource.channelURI)
    Call<Channel> patchChannel(@Path("channel_id") String channelId,
                              @Path("role_id") String roleID,
                              @Body ChannelValueObject value);


    // DeleteChannel 删除指定子频道
    @DELETE(Resource.channelURI)
    Call<Channel> deleteChannel(@Path("channel_id") String channelId);


    // CreatePrivateChannel 创建私密子频道，底层是用的是 PostChannel 能力
    // ChannelValueObject 中的 PrivateType 不需要填充，本方法会自动填充
    @GET(Resource.channelURI)
    Call<Channel> createPrivateChannel(@Path("guild_id") String guildID,
                               @Body ChannelValueObject value);


    // ListVoiceChannelMembers 查询语音子频道成员列表
    @GET(Resource.voiceChannelMembersURI)
    Call<Member[]> listVoiceChannelMembers(@Path("channel_id") String channelId);


}
