package cn.blankcat.openapi.v1.service;

import cn.blankcat.dto.channel.ChannelPermissions;
import cn.blankcat.dto.channel.ChannelRolesPermissions;
import cn.blankcat.dto.channel.UpdateChannelPermissions;
import cn.blankcat.openapi.v1.Resource;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.PUT;
import retrofit2.http.Path;

public interface ChannelPermissionService{

    // ChannelPermissions 获取指定子频道的权限
    @GET(Resource.channelPermissionsURI)
    Call<ChannelPermissions> postAudio(@Path("channel_id") String channelId,
                                       @Path("user_id") String userID);

    // ChannelRolesPermissions 获取指定子频道身份组的权限
    @GET(Resource.channelRolesPermissionsURI)
    Call<ChannelRolesPermissions> putMic(@Path("channel_id") String channelId,
                                         @Path("role_id") String roleID);

    // PutChannelPermissions 修改指定子频道的权限
    @PUT(Resource.channelPermissionsURI)
    Call<String> deleteMic(@Path("channel_id") String channelId,
                           @Path("user_id") String userID,
                           @Body UpdateChannelPermissions p);

    // PutChannelRolesPermissions 修改指定子频道的权限
    @PUT(Resource.channelRolesPermissionsURI)
    Call<String> putChannelRolesPermissions(@Path("channel_id") String channelId,
                                            @Path("role_id") String roleID,
                                            @Body UpdateChannelPermissions p);

}
